(setf *print-help-mode* nil)
(setf *lispboss* nil)
(setf *load-files-with-running-vista* nil)
(setf *SELECTOR* nil)
(setf *logo* nil)
(setf *create-vista* t)
(setf *vista-exists* nil)
(setf *hide-logo* nil)
(setf *hide-vista* nil)
(setf *hide-desktop* *hide-vista*)
(setf *start-manager* nil)
(setf *vue-manager* nil)
(setf *startup-code* nil)
(setf *vista-applet* nil)
(setf *vista-data* nil)
(setf *dde-data* nil)
(setf *vdf-data* nil)
(setf *vaf-progn* nil)
(setf *vista-startup-error* nil)

(setf  *VISTA-HAS-BEEN-SHOWN* nil)
(set (intern (string-upcase "nan")) machine-epsilon)
(set (intern (string-upcase "~~~")) machine-epsilon)
(set (intern (string-upcase "---")) machine-epsilon)
(setf *missing-value-symbol* '---)
(setf *character-missing-value* "")
(setf *numeric-missing-value* ---)


(setf *current-datasheet* nil)
  (setf current-datasheet nil)
  (setf *cds* nil)
  (setf cds nil)
  (setf $$$ nil)
  (setf @ nil)

(defun missingp-fwy (datum)
  (cond
    ((or (symbolp datum) (stringp datum))
     (equal datum *character-missing-value*))
    ((numberp datum)
     (= datum *numeric-missing-value*))
    (t (error "Data values must be a symbol, string or number, including the missing value indicator ~a for character data and ~a for numeric data." *character-missing-value* *numeric-missing-value*))))

(setf *broken-bar* "")
(setf *paragraph* "")
(setf *copyright* "")
(setf *beta* "")
(setf *alpha* "")


(setf *drag-icon-image* nil)
(setf *show-info* nil)
(setf *dash-edit-button-bar* nil)
(setf *auto-type-shift* nil)
(setf *auto-activate* nil)
(setf *history* nil)
(setf *startup-verbose* nil)
(setf *long-varobs* nil)
(setf *dsname-separator* *paragraph*)
(setf *MENU-ITEM-HELP-CONTROL-PANEL*  nil)
(setf *doco-screen-size* '(600 420))
(setf *viva* nil)
(setf *show-datasheet-after-loading-data* t)
(setf *edit-lisp-files* t)
(defconstant dblquote (code-char 34))
(setf *full-screen-desktop* nil)
(setf *CURRENT-DATASHEET* nil)
(setf *deskup-time* 0)
(setf *bottom-line* nil)
(setf *pref-filenames* (list "wrkmpgui" "workmap" "version" "verbose" "prefs" "prefload" "plgingui" "initial" "dsktpgui" "desktop"))
(setf *starter* nil)
(setf *clock* nil)
(setf *show-clock-logo* nil)
(setf *clock-hides-desktop* nil)
(setf *full-screen-clock* nil)
(setf *dynamic-clock-logo* nil)
(setf *show-elapsed-time* t)
(setf *desktop-layout-state* 3)
(setf *excel.exe* nil)
(setf *browser.exe* nil)
(setf *text-editor.exe* nil)
(setf *printer.exe* nil)
(setf *MAXIMIZE-SPREADPLOTS* nil)
(setf *layout-choice* 2)
(setf *xlispstat-only* nil)
(setf *screen-saver-full-screen* nil)
(setf *log-verbose* nil)
(setf *maker-error-flag* t)
(setf *dde-data* nil)
(setf $data nil)
(setf $vars nil)
(setf $variables nil)
(setf $free-vars nil)
(setf $all-vars nil)
(setf $data-vars nil)
(setf $data-variables nil)
(setf $desk-vars nil)
(setf $desk-variables nil)
(setf $viva-vars nil)
(setf $viva-variables nil)
;(setf $.* nil)
(setf $.$ nil)
(setf *.* nil)
(setf !.* nil)

(setf *clock-hides-desktop* t) 
(setf *full-screen-clock* nil) 
(setf *dynamic-clock-logo* t) 
(setf *show-elapsed-time* nil) 

(setf *BAKTRACER-VERBOSE* t)
(setf *SHOWN-EXCEL-VISTA-CONNECTION-WARNING?* nil)

; these functions define initial variables and must be here

(setf *initial-button-names* 
      (list "ANOVA" "Regres" "UniVar"))

;see vismenu1.lsp for initialiation of menu items


(defproto expert-menu-item-proto () () menu-item-proto)

;fwy4.28 7/16/97 modified so that menu items can show help
;fwy 09-20-02 modified to eliminate datasheet mode

(defmeth expert-menu-item-proto :do-action ()
;(print (list (if (send *vista* :show-help) "show help" "do menu action") "expert"
;             (if *print-help-mode* "print help" "show help")))
  (cond
    ((not (send *vista* :show-help))
     (when (and (equal $$$ @)
                (member (send self :menu)
                        (list *data-menu* *trans-menu* *spreadplot-menu* 
                              *graphics-menu* *analyze-menu*)))
           (setcd (first (send @ :dob-parents))))
     (when (author) (copyitem (send self :title)))
     (when (send self :action) (funcall (send self :action))))
    (t
     (unless (ignore-errors 
              (send *workmap* :show-help self t "title" t t (not *print-help-mode*)))
             (send *vista* :show-help nil)
             (cond 
               (*print-help-mode* 
                (send *help-window* :close)
                (send *desktop-container* :resize))
               (t
                (one-button-dialog 
                 "I'm sorry, but there is no help for this menu item."
                 :title "Help: Missing Help File"
                 :first-button "Oops ... My mistake :-(")
                (top-level nil)))))
    ))
#|
(defmeth expert-menu-item-proto :do-action ()
  ;following when statement part of changes that eliminate 
  ;the "datasheet mode" in which menus etc are unavailable 
  ;when a datasheet is active.
  ;what it does is that when a menu item is used the item first
  ;checks to see if the current object is a datasheet and if the
  ;menu is a relevant menu. if so the menu item changes the 
  ;current object to the datasheet's data parent
  (cond
    ((send *vista* :show-help)
(break)
     (when (and (not @) (equal $$$ @)
                (member (send self :menu)
                        (list *data-menu* *trans-menu* *spreadplot-menu* 
                              *graphics-menu* *analyze-menu*)))
           (setcd (first (send @ :dob-parents))))
     (when (author) (copyitem (send self :title)))
     (send *workmap* :show-help self)
     (unless (ignore-errors (send *workmap* :show-help self))
             (unless *print-help-mode*
                     (help "I'm sorry, there is no help for this menu item.")))
     ;(send *vista* :show-help nil)
     )
    (t (when (send self :action) (funcall (send self :action))))))


(defmeth expert-menu-item-proto :do-action ()
  ;following when statement part of changes that eliminate 
  ;the "datasheet mode" in which menus etc are unavailable 
  ;when a datasheet is active.
  ;what it does is that when a menu item is used the item first
  ;checks to see if the current object is a datasheet and if the
  ;menu is a relevant menu. if so the menu item changes the 
  ;current object to the datasheet's data parent
  (when (and (not (send *vista* :show-help))
             (equal $$$ @)
             (member (send self :menu)
                     (list *data-menu* *trans-menu* *spreadplot-menu* ;fwy adds splot 12/15/02
                           *graphics-menu* *analyze-menu*)))
        (setcd (first (send @ :dob-parents))))
  (when (and (not (send *vista* :show-help)) (author)) (copyitem (send self :title)))
  (when (send *vista* :show-help)
        (unless (ignore-errors (send *workmap* :show-help self))
                (send *vista* :show-help nil)
                (cond 
                  (*print-help-mode* 
                   (send *help-window* :close)
                   (send *desktop-container* :resize))
                  (t
                   (one-button-dialog 
                    "I'm sorry, but there is no help for this menu item."
                    :title "Help: Missing Help File"
                    :first-button "Oops ... My mistake :-(")
                   (top-level nil)))
                ))
  (when (not (send *vista* :show-help))
        (when (send self :action)
              (funcall (send self :action)))))

|#

(defvar *analyze-menu* (send menu-proto :new "Analyze"))
(defvar *tools-menu* *analyze-menu* );fwy4.25
(send   *analyze-menu* :enabled nil)

(setf anova-model-menu-item
      (send expert-menu-item-proto :new "Analysis of Variance ..." 
            :enabled nil
            :action  #'(lambda () (analysis-of-variance :dialog t))))

(setf reg-model-menu-item
      (send expert-menu-item-proto :new "Regression Analysis ..." 
            :enabled nil
            :action #'(lambda () (regression-analysis :dialog t))))

(setf univar-model-menu-item
      (send expert-menu-item-proto :new "Univariate Analysis ..." 
            :enabled nil
            :action #'(lambda () (univariate-analysis :dialog t))))

(send *analyze-menu* :append-items
     anova-model-menu-item reg-model-menu-item univar-model-menu-item)

(setf *initial-analysis-menu-items* 
      (list "Analysis of Variance" 
            "Regression Analysis" 
            "Univariate Analysis"))

(setf *initial-analysis-symbols* 
      (list
       'anova-model-menu-item 
       'reg-model-menu-item
       'univar-model-menu-item))

(setf *initial-analysis-datatypes*
      (list (list "class" "general" "crosstabs" )     ;ANOVA  "class" "multivariate"
            (list "multivariate" "bivariate" "crosstabs" "general") ;Regres
            (list "general" "crosstabs" "class"
                  "univariate" "bivariate" "multivariate");UniVar
            ))

(setf *install-developer* nil)
(setf *maximized-listener?* t)
(setf *default-num-listener-lines* 4)
(setf *force-user-mode* nil)
(setf *user-mode* t)
(setf *after-making-vista-choice* 0)
(setf *make-vista-configuration-choice* 0)
(setf *autoshow-model-reports* nil)
(setf *autoshow-model-visuals* nil)
(setf *phase0-id* "0")
(setf *phase1-id* "0")
(setf *phase2-id* "0")
(setf *phase3-id* "0")
(setf *phase4-id* "0")



(setf  *local-vista-id-number* nil)
(setf  *vista-id-number* nil)
(setf  *registration-number* nil)
(setf  *install-id* nil)
(setf  *vista-id-number* nil)
(setf  *vista-id* nil)
(setf  *compile-id* nil)
(setf  *distribution-id* nil)
(setf  *distributor-id* nil)
(setf  *builder-id* nil)
(setf  *compile-date* nil)
(setf  *build-date* nil)
(setf  *distribution-date* nil)
(setf  *install-date* nil)

(setf *vista-start-case* 0)
(setf *button-names* *initial-button-names* )
(setf *analysis-menu-items* *initial-analysis-menu-items*)
(setf *nplugins* 0)                  ;number of plugin objects
(setf *nmobs*  (length *button-names*))  ;number of model objects
(setf *initial-nmobs* *nmobs*)
(setf *nanalys* (+ *nplugins* *nmobs*));number of analysis methods
(setf *nitems* *nanalys*)            ;number of analysis menu items
(setf *nbutts* *nanalys*)            ;number of toolbar buttons
(setf *NUM-TOOLBAR-BUTS-SHOWN-AT-STARTUP* *nmobs*)
(setf *compiled-file-listing?* nil)
(setf *show-make-steps?* nil)
(setf *Distribution-WorkSpace?* nil)
(setf *local-install-number* 0)
(setf *real-screen-size* (screen-size))
(setf viva-verbose t)
(setf *xlisponly* nil)
(setf *switching-to-xlisponly* nil)
(setf *initial-install* nil) ;(setf *initial-install* t)
(setf *no-restart* nil)        ;(setf *no-restart* nil)
(setf *config-vistaxls* t) ;(setf *config-vistaxls* t)
(setf *make-distribution* nil)
(setf *installation-phase* 0)
(setf ini-exists? nil)
(setf *ini-file* nil)
(setf *ini-at-home* t)
(setf *dde-data* nil)
#+msdos(setf *listener* nil)
(setf *visible-startup* nil)
(setf *install-date* nil)
(setf *pro-version* nil)
(setf *devel-menu* nil)
(setf *devel-mode* nil)
(setf *num-listener-lines* 4)
(setf *container-verbose* nil)
(setf *please-wait* nil)
(setf *show-zooming-desktop* nil)
(setf *show-flying-exit-logo* nil)
(setf *show-install-logo* nil)
(setf *frames-per-second* nil)
(setf *setup-time* nil)
(setf *MISSING-REPORT-WINDOW* nil)
(setf *installation-type* nil)
(setf *computing-environment* nil)
(setf *seamless-spreadplots* t)
(setf *seamless-desktop* nil)
(setf *thin-borders* t)

(setf *about-window* nil)
(setf *post-it-window* nil)
(setf *help-window* nil)
(setf *chain-window* nil)
(setf *devel-version* nil) ;never change this except by creators key
(setf *pro-version* nil)   ;never change this except by developers key
(setf *new-interface-mode* nil)
(setf *ni* t)
(setf *plotcell-pane-type* 7)
(setf *one-window-spreadplots* nil)
(setf *free-spreadplots* t)
(setf *one-window-desktop* t)
(setf screen-size (list 0 0))
(setf *screen-size* (list 0 0))
(setf *now-screen-size* (list 0 0))
(setf *max-screen-size* (list -1 -1))
(setf *previous-max-screen-size* (list 0 0))
(setf *full-screen* t)
(setf *layout-type* 2)
(setf *macos8* nil)
(setf *custom-dialog* nil)
(setf *registered?* nil)
(setf *user-type* "User")
(setf *installer-type* "User")
(setf *fast-start* nil)

(setf *font-and-dir-setting-mode* nil)
(setf *font-setting-mode* nil)
(setf *directory-setting-mode* nil)
(setf *no-dir-dialog* nil)
(setf *changed-user-dir-name* nil)


(setf *restart* t)
(setf *change-fonts* nil)
(setf *change-directories* nil)
(setf *change-toolbar* nil)
(setf *change-excess* nil)
;(setf *excel-configured?* nil)
(setf *local-excel?* nil)
(setf *no-local-excel?* t)
(setf *show-configure-no-local-excel-menu-item* nil)
(setf *show-configure-local-excel-menu-item* nil)
;(setf *configure-excel* nil)
;(setf *configure-access* nil)

(setf *standard-installation* t)

(setf *default-workmap-proportion* .5)
(setf *needs-desktop-resized* nil)
(setf *desktop-container* nil)
(setf *spreadplot-container* nil)
(setf *report-container* nil)
(setf *mainwindow-loc-size* nil)
(setf *mainwindow-start-loc-size* nil)
(setf *desktop-loc-size* nil)
(setf *desktop-start-loc-size* nil)
(setf *seven-values* '(600 400 4 24 1 600 400))
(setf *default-seven-values* '(600 400 4 24 1 600 400))
(setf *listener-loc-size* nil)
(setf *listener-start-loc-size* nil)
(setf *free-about-window* t)



  (setf *border-style* 0)
  (setf *desktop-datasheet* nil)
  (setf *vv* nil)
  (setf *version6* t)
  (setf *initial-datasheet* t)
  (setf *free-datasheets* nil)
  (setf *free-text-windows* t)
 
(setf *vista* nil)
(setf *expertmap* nil)
(setf *line-width* 2)
(setf *update-pref-files* t)
(setf *show-devel-menu* nil)
(setf *show-web-docs* t)
(setf *one-click-workmap* t)
(setf *realtime-datasheet-update* t)
(setf *max-load-speed* t)
(setf *screen-saver* nil) ; screen-saver object-id
(setf *enable-screen-saver-feature* t)
(setf *current-spreadplot* nil)

;see (define-vista-paths) function in defun2.lsp

(setf *system-path*              "C:\\Windows\\System\\")           ;08/08/00
(setf *prgfil-path*              "C:\\Program Files\\")             ;10/12/00
(setf *prgfil-path-default*      *prgfil-path*)
(setf *system-path-default*      *system-path*)
(setf *working-dir*              *default-path*);06/30/00
(setf *working-path*             *default-path*);06/30/00
(setf *startup-dir-name*         *default-path*);06/30/00
(setf *lib-path*                 *default-path*)
(setf *xlib-path*                *default-path*)
(setf *prefs-dir-name*   (strcat *default-path* "prefs"    *separator*))
;(setf *user-dir-name*   (strcat *default-path* "user"     *separator*))
;(setf *user-path*       (strcat *default-path* "user"     *separator*))
(setf *prefs-path*       (strcat *default-path* "prefs"    *separator*))
(setf *base-dir-name*    (strcat *default-path* "source"   *separator*))
(setf *source-dir-name*  (strcat *default-path* "source"   *separator*))
(setf *code-dir-name*    (strcat *default-path* "fslfiles" *separator*))
(setf *fsl-dir-name*     (strcat *default-path* "fslfiles" *separator*))
(setf *runtime-dir-name* (strcat *default-path* "runtime"  *separator*))
(setf *plugin-dir-name*  (strcat *default-path* "plugins"  *separator*))
(setf *plugins-dir-name* (strcat *default-path* "plugins"  *separator*))
(setf *plugins-path*     (strcat *default-path* "plugins"  *separator*))
(setf *plugin-path*      (strcat *default-path* "plugins"  *separator*))
(setf *vista-dir-name*   (strcat *default-path* "runtime"  *separator*));06/30/00
(setf *example-dir-name* (strcat *default-path* "examples" *separator*));06/30/00
(setf *examples-dir-name*(strcat *default-path* "examples" *separator*));06/30/00
(setf *help-dir-name*    (strcat *default-path* "help"     *separator* "help"     *separator*));06/30/00
(setf *guide-dir-name*   (strcat *default-path* "help"     *separator* "guidance" *separator*));06/30/00
(setf *data-path* (strcat *default-path* "data"    *separator*))
(setf *data-dir-name*    *data-path*)
(setf *user-path* (make-pathname :directory '(:relative "C:" "ViSta" "MyData")))
(setf *user-dir-name* *user-path*)
(setf *current-user-dir-name* *user-path*)
(setf *current-data-dir-name* *user-path*)
(setf *examples-data-dir-name* *user-path*)
(setf prefs-dir? nil)

(setf *about-spot* nil)
(setf *browser* nil)

(setf *current-object* nil)
(setf *hide-vista* nil)
(setf *front-window* nil)
(setf *front-plotcell* nil)
(setf *open-spreadplots* nil)
(setf *show-flying-logo* nil)
(setf *rebuild-after-compile-needed* t)
(setf *COMPILE-AFTER-LOADING-NEEDED* nil)


(defun define-color-variables ()
  (setf *workmap-background* '(1 1 1)) ;.857 1 1
  (setf *toolbar-background* '(0.857 1 0.857))
  (setf *data-icon-color*    '(0 1 0)) ;'(.5 .5 1)
  (setf *model-icon-color*   '(0.8 0.6 0.2))
  (setf *data-icon-cap-color*  '(1 0 0))
  (setf *weak-data-icon-cap-color*  (/ (+ 4 *data-icon-cap-color*) 5))
  (setf *model-icon-cap-color* '(0 1 0))
  (setf *weak-model-icon-cap-color*  (/ (+ 4 *model-icon-cap-color*) 5))
;next six colors changed by fwy 091602
  (setf *freq-icon-color*      *data-icon-color*)
  (setf *freqclass-icon-color* *data-icon-color*)
  (setf *mv-icon-color*        *data-icon-color*)
  (setf *class-icon-color*     *data-icon-color*)
  (setf *cat-icon-color*       *data-icon-color*)
  (setf *missing-icon-color*   *data-icon-color*)
  (setf *dissim-icon-color*    *data-icon-color*)
  ;(setf *freq-icon-color*    '(1 0.6 0.6))
  ;(setf *freqclass-icon-color* '(0.6 0.6 1))
  ;(setf *mv-icon-color*      '(0.2 0.6 0.6))
  ;(setf *class-icon-color*   '(0 0.5 0))
  ;(setf *cat-icon-color*     '(1 0 0))
  ;(setf *missing-icon-color* '(1 0 0))
  ;(setf *dissim-icon-color*  '(0.6 0.4 0.4))
  (setf *tool-icon-color*    '(0 0.571 0.857))
  (setf *guide-icon-color*   '(0.75 0 0))
  (setf *button-on-color*    '(1 0 0))
  (setf *button-off-color*   '(1 1 1)))

(defun default-colors ()
"For ViSta\'s colors that can be changed by the ViSta color controller, sets their color symbols to the preferred defaults"
  (apply #'make-color 'toolbar-background   *toolbar-background*)
  (apply #'make-color 'workmap-background   *workmap-background*)
  (apply #'make-color 'data-icon-color      *data-icon-color*)
  (apply #'make-color 'model-icon-color     *model-icon-color*)
  (apply #'make-color 'data-icon-cap-color  *data-icon-cap-color*)
  (apply #'make-color 'weak-data-icon-cap-color *weak-data-icon-cap-color*)
  (apply #'make-color 'weak-model-icon-cap-color *weak-model-icon-cap-color*)
  (apply #'make-color 'model-icon-cap-color *model-icon-cap-color*)
  (apply #'make-color 'freq-icon-color      *freq-icon-color*)
  (apply #'make-color 'freqclass-icon-color *freqclass-icon-color*)
  (apply #'make-color 'mv-icon-color        *mv-icon-color*)
  (apply #'make-color 'class-icon-color     *class-icon-color*)
  (apply #'make-color 'cat-icon-color       *cat-icon-color*)
  (apply #'make-color 'missing-icon-color   *missing-icon-color*)
  (apply #'make-color 'dissim-icon-color    *dissim-icon-color*)
  (apply #'make-color 'tool-icon-color      *tool-icon-color*)
  (apply #'make-color 'guide-icon-color     *guide-icon-color*)
  (apply #'make-color 'button-on-color      *button-on-color*)
  (apply #'make-color 'button-off-color     *button-off-color*)
  )

;(define-color-variables)

(defun define-vista-color-constants ()
  (defconstant *never-shown-color* '(.50 .50 .50))
  (defconstant *logo-background* '(.75 1 1))
  (defconstant *post-it-yellow* '(1 1 .75)) ; 1 1 .8
  (defconstant *dark-green* '(0 .5 0))
  (defconstant *brown* '(.625 .375 .375))
  (defconstant *violet* '(.625 .25 .875))
  (defconstant *dark-violet* (list .42 .18 .47))
  (defconstant *medium-blue* (list .7 .7 1))
  (defconstant *dark-red* '(.75 .25 .625))
  (defconstant *gray* '(.5 .5 .5))
  (defconstant *grey* *gray*)
  (defconstant *medium-gray* '(.6 .6 .6))
  (defconstant *grey1* '(.75 .75 .75))
  (defconstant *light-gray* *grey1*)
  (defconstant *light-grey* *grey1*)
  (defconstant *light-blue* '(.9 .985 1)) ; .675 .95 1 
  (defconstant *light-yellow* '(1 1 .75 )) ; 1 1 .95 
  (defconstant *light-red* '(1 .95 .95))
  (defconstant *pink* *light-red*)
  (defconstant *new-icon-color*     '(1 .4 0))
  (defconstant *orange* '(1 .8 0))
  (defconstant *light-orange* '(1 .9 .7))
  )

(defun define-vista-color-constant-symbols ()
  "Creates color-symbols and binds values for ViSta color constants"
  (apply #'make-color 'new-icon-color       *new-icon-color*)
  (apply #'make-color 'never-shown-color    *never-shown-color*)
  (apply #'make-color 'post-it-yellow       *post-it-yellow*)
  (apply #'make-color 'dark-green *dark-green*)
  (apply #'make-color 'brown *brown*)
  (apply #'make-color 'violet *violet*)
  (apply #'make-color 'dark-violet *dark-violet*)
  (apply #'make-color 'dark-red *dark-red*)
  (apply #'make-color 'medium-blue *medium-blue*)
  (apply #'make-color 'gray *gray*)
  (apply #'make-color 'grey *grey*)
  (apply #'make-color 'grey1 *grey1*)
  (apply #'make-color 'medium-grey *medium-gray*)
  (apply #'make-color 'medium-gray *medium-gray*)
  (apply #'make-color 'light-grey *grey1*)
  (apply #'make-color 'light-gray *grey1*)
  (apply #'make-color 'light-blue    *light-blue*)
  (apply #'make-color 'light-red     *light-red*)
  (apply #'make-color 'light-yellow  *light-yellow*)
  (apply #'make-color 'orange  *orange*)
  (apply #'make-color 'light-orange  *light-orange*)
  (apply #'make-color 'pink  *pink*)
  )

(defun make-vista-color-variables ()
"For ViSta\'s colors that can be changed by the ViSta color controller, creates color symbols and sets them to their original distribution default values."
  (define-color-variables)
  (default-colors)
  t)

(defun make-vista-color-constants ()
"Defines ViSta color constant symbols and values."
  (define-vista-color-constants)
  (define-vista-color-constant-symbols)
  t)

(defun reset-vista-colors () 
  (make-vista-color-constants) 
  (make-vista-color-variables)
  t)

(defun make-vista-colors ()
"Makes all of ViSta\'s colors, both variables and constants, and sets them to their default distribution values."
  (make-vista-color-variables)
  (make-vista-color-constants)
  t)

